/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;

public class BukkitWolf
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private boolean angry = false;
    private DyeColor color = null;
    private boolean tameable = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.angry = mc.getBoolean("Options.Angry", false);
        this.tameable = mc.getBoolean("Options.Tameable", false);
        String strColor = mc.getString("Options.Color");
        if (strColor != null) {
            try {
                this.color = DyeColor.valueOf((String)strColor);
            }
            catch (Exception exception) {
                MythicLogger.errorGenericConfig("Invalid collar color specified");
            }
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.WOLF, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Wolf e = (Wolf)entity;
        e = (Wolf)this.ageableProperty.applyProperties((Entity)e);
        e.setAngry(this.angry);
        if (this.color != null) {
            e.setCollarColor(this.color);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Wolf;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    public AbstractPlayer getOwner(ActiveMob am) {
        Wolf w;
        Entity e = BukkitAdapter.adapt(am.getEntity());
        if (e instanceof Wolf && (w = (Wolf)e).getOwner() instanceof Player) {
            return BukkitAdapter.adapt((Player)w.getOwner());
        }
        return null;
    }
}

