/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.MerchantProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

public class BukkitVillager
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private MerchantProperty merchantProperty;
    private Villager.Type villagerType;
    private Villager.Profession villagerProfession;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.merchantProperty = new MerchantProperty(mc);
        String strVillagerProfession = mc.getString("Options.Profession", "RANDOM");
        strVillagerProfession = mc.getString("Options.VillagerType", strVillagerProfession);
        try {
            this.villagerProfession = strVillagerProfession.equals("RANDOM") ? null : Villager.Profession.valueOf((String)strVillagerProfession);
        }
        catch (Exception ex) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid Villager Profession specified");
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
            String strVillagerType = mc.getString("Options.Type", "RANDOM");
            try {
                this.villagerType = strVillagerType.equals("RANDOM") ? null : Villager.Type.valueOf((String)strVillagerType);
            }
            catch (Exception ex) {
                MythicLogger.errorEntityConfig(this, mc, "Invalid Villager Type specified");
            }
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.VILLAGER, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Villager e = (Villager)entity;
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && this.villagerType != null) {
            e.setVillagerType(this.villagerType);
        }
        if (this.villagerProfession != null) {
            e.setProfession(this.villagerProfession);
        } else if (this.merchantProperty.hasTrades()) {
            e.setProfession(Villager.Profession.NITWIT);
        }
        this.ageableProperty.applyProperties(entity);
        this.merchantProperty.applyProperties(entity);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Villager;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

