/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TropicalFish;

public class BukkitTropicalFish
extends BukkitEntityType {
    private static final int height = 1;
    private TropicalFish.Pattern pattern = null;
    private DyeColor bodyColor = null;
    private DyeColor patternColor = null;

    @Override
    public void instantiate(MythicConfig mc) {
        String strPattern = mc.getString("Options.Pattern", null);
        String strBodyColor = mc.getString("Options.BodyColor", null);
        String strPatternColor = mc.getString("Options.PatternColor", null);
        if (strPattern != null) {
            try {
                this.pattern = TropicalFish.Pattern.valueOf((String)strPattern.toUpperCase());
            }
            catch (Exception ex) {
                MythicLogger.errorEntityConfig(this, mc, "Invalid Pattern specified");
            }
        }
        if (strBodyColor != null) {
            try {
                this.bodyColor = DyeColor.valueOf((String)strBodyColor.toUpperCase());
            }
            catch (Exception ex) {
                MythicLogger.errorEntityConfig(this, mc, "Invalid BodyColor specified");
            }
        }
        if (strPatternColor != null) {
            try {
                this.patternColor = DyeColor.valueOf((String)strPatternColor.toUpperCase());
            }
            catch (Exception ex) {
                MythicLogger.errorEntityConfig(this, mc, "Invalid PatternColor specified");
            }
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.TROPICAL_FISH, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        TropicalFish e = (TropicalFish)entity;
        if (this.pattern != null) {
            e.setPattern(this.pattern);
        }
        if (this.bodyColor != null) {
            e.setBodyColor(this.bodyColor);
        }
        if (this.patternColor != null) {
            e.setPatternColor(this.patternColor);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof TropicalFish;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

