/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Snowman;

public class BukkitSnowman
extends BukkitEntityType {
    private static final int height = 2;
    private boolean preventSnowFormation = false;
    private boolean isDerp = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.preventSnowFormation = mc.getBoolean("Options.PreventSnowFormation", false);
        this.isDerp = mc.getBoolean("Options.Derp", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.SNOWMAN, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Snowman e = (Snowman)entity;
        e.setDerp(this.isDerp);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Snowman;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    public boolean getPreventSnowFormation() {
        return this.preventSnowFormation;
    }
}

