/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Shulker;

public class BukkitShulker
extends BukkitEntityType {
    private static final int height = 2;
    private DyeColor color;

    @Override
    public void instantiate(MythicConfig mc) {
        try {
            this.color = DyeColor.valueOf((String)mc.getString("Options.Color", "PURPLE"));
        }
        catch (Exception exception) {
            MythicLogger.errorGenericConfig("Invalid dye color specified");
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.SHULKER, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Shulker e = (Shulker)entity;
        e.setColor(this.color);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitShulker.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        return e instanceof Shulker;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

