/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Llama;

public class BukkitLlama
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private Llama.Color color;
    private boolean carryingChest;
    private boolean tamed;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.carryingChest = mc.getBoolean("Options.CarryingChest", false);
        this.tamed = mc.getBoolean("Options.Tamed", false);
        String strColor = mc.getString("Options.Color", "WHITE");
        try {
            this.color = Llama.Color.valueOf((String)strColor.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid Llama color specified");
            this.color = Llama.Color.WHITE;
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Llama e = (Llama)this.spawnEntity(location, EntityType.LLAMA, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Llama e = (Llama)entity;
        this.ageableProperty.applyProperties(entity);
        e.setColor(this.color);
        if (this.carryingChest) {
            e.setCarryingChest(true);
        }
        if (this.tamed) {
            e.setTamed(true);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Llama;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

