/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Goat;

public class BukkitGoat
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private boolean screaming;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.screaming = mc.getBoolean("Options.Screaming", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.GOAT, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Goat e = (Goat)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.screaming) {
            e.setScreaming(true);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Goat;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

