/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;

public class BukkitExperienceOrb
extends BukkitEntityType {
    private static final int height = 1;
    private PlaceholderInt amount;

    @Override
    public void instantiate(MythicConfig mc) {
        String exp = mc.getString("Options.Experience", "1");
        try {
            this.amount = PlaceholderInt.of(exp);
        }
        catch (Exception ex) {
            MythicLogger.errorGenericConfig("Invalid experience amount specified");
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.EXPERIENCE_ORB, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        ExperienceOrb xp = (ExperienceOrb)entity;
        xp.setExperience(this.amount.get());
        return xp;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof ExperienceOrb;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

