/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitCreeper
extends BukkitEntityType {
    private static final int height = 2;
    private boolean powered = false;
    private boolean preventSuicide = false;
    private int explosionFuseTicks = -1;
    private int explosionRadius = -1;

    @Override
    public void instantiate(MythicConfig mc) {
        this.powered = mc.getBoolean("Options.SuperCharged", false);
        this.preventSuicide = mc.getBoolean("Options.PreventSuicide", false);
        this.explosionFuseTicks = mc.getInteger("Options.FuseTicks", -1);
        this.explosionRadius = mc.getInteger("Options.ExplosionRadius", -1);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.CREEPER, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Creeper e = (Creeper)entity;
        if (this.powered) {
            e.setPowered(true);
        }
        if (this.explosionFuseTicks >= 0) {
            e.setMaxFuseTicks(this.explosionFuseTicks);
        }
        if (this.explosionRadius >= 0) {
            e.setExplosionRadius(this.explosionRadius);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Creeper;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    public boolean preventSuicide() {
        return this.preventSuicide;
    }
}

