/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;

public class BukkitBabyPiglinBrute
extends BukkitEntityType {
    private static final int height = 2;
    private boolean immuneToZombification = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.immuneToZombification = mc.getBoolean("Options.ImmuneToZombification", true);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        PiglinBrute e = (PiglinBrute)this.spawnEntity(location, EntityType.PIGLIN_BRUTE, reason, prespawnFunc);
        e.setBaby(true);
        e.setAgeLock(true);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        PiglinBrute z = (PiglinBrute)entity;
        z.setBaby(true);
        z.setAgeLock(true);
        z.setImmuneToZombification(this.immuneToZombification);
        return z;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Piglin && ((Piglin)e).isBaby();
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

