/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitAxolotl
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private boolean tameable;
    private String type;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.tameable = mc.getBoolean("Options.Tameable", false);
        this.type = mc.getString("Options.Type", null);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        return this.spawnEntity(location, EntityType.AXOLOTL, reason, prespawnFunc);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Axolotl e = (Axolotl)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.type != null) {
            e.setVariant(Axolotl.Variant.valueOf((String)this.type.toUpperCase()));
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Axolotl;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isTameable() {
        return this.tameable;
    }
}

