/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractBiome;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class BukkitWorld
implements AbstractWorld {
    private transient WeakReference<World> worldRef;
    private UUID uuid;
    private String name;
    private static final Map<Integer, Effect> effects = new HashMap<Integer, Effect>();

    public BukkitWorld() {
        World w = Bukkit.getWorld((UUID)this.uuid);
        this.worldRef = new WeakReference<World>(w);
    }

    public BukkitWorld(World w) {
        this.worldRef = new WeakReference<World>(w);
        this.uuid = w.getUID();
        this.name = w.getName();
    }

    public BukkitWorld(String world) {
        World w = Bukkit.getWorld((String)world);
        this.worldRef = new WeakReference<World>(w);
        if (this.worldRef != null && this.worldRef.get() != null) {
            this.uuid = w.getUID();
        }
        this.name = world;
    }

    public World getBukkitWorld() {
        if (this.worldRef.get() == null) {
            if (Bukkit.getWorld((String)this.name) != null) {
                this.worldRef = new WeakReference<World>(Bukkit.getWorld((String)this.name));
            } else {
                return null;
            }
        }
        return (World)this.worldRef.get();
    }

    @Override
    public boolean isLoaded() {
        return this.getBukkitWorld() != null;
    }

    @Override
    public List<AbstractEntity> getLivingEntities() {
        ArrayList<AbstractEntity> wl = new ArrayList<AbstractEntity>();
        if (this.getBukkitWorld() == null) {
            return wl;
        }
        for (LivingEntity e : this.getBukkitWorld().getLivingEntities()) {
            wl.add(new BukkitEntity((Entity)e));
        }
        return wl;
    }

    @Override
    public String getName() {
        if (this.getBukkitWorld() == null) {
            return this.name;
        }
        return this.getBukkitWorld().getName();
    }

    @Override
    public UUID getUniqueId() {
        if (this.getBukkitWorld() == null) {
            return this.uuid;
        }
        return this.getBukkitWorld().getUID();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BukkitWorld) {
            if (((BukkitWorld)other).getBukkitWorld() == null) {
                return false;
            }
            return ((BukkitWorld)other).getBukkitWorld().equals(this.getBukkitWorld());
        }
        if (other instanceof AbstractWorld) {
            return ((AbstractWorld)other).getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        if (this.getBukkitWorld() == null) {
            return -1;
        }
        return this.getBukkitWorld().hashCode();
    }

    public int getMaxY() {
        return this.getBukkitWorld().getMaxHeight() - 1;
    }

    @Override
    public void createExplosion(AbstractLocation l, float f) {
        if (this.getBukkitWorld() == null) {
            return;
        }
        this.getBukkitWorld().createExplosion(BukkitAdapter.adapt(l), f);
    }

    @Override
    public void createExplosion(AbstractLocation l, float yield, boolean fire, boolean blockdamage) {
        if (this.getBukkitWorld() == null) {
            return;
        }
        this.getBukkitWorld().createExplosion(l.getX(), l.getY(), l.getZ(), yield, fire, blockdamage);
    }

    @Override
    public List<AbstractPlayer> getPlayers() {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        for (Player p : this.getBukkitWorld().getPlayers()) {
            pl.add(BukkitAdapter.adapt(p));
        }
        return pl;
    }

    @Override
    public Collection<AbstractPlayer> getPlayersInRadius(AbstractLocation center, double radiusSq) {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        Location location = BukkitAdapter.adapt(center);
        for (Player player : this.getBukkitWorld().getPlayers()) {
            if (!(player.getLocation().distanceSquared(location) <= radiusSq)) continue;
            pl.add(BukkitAdapter.adapt(player));
        }
        return pl;
    }

    @Override
    public void setStorm(boolean b) {
        this.getBukkitWorld().setStorm(b);
    }

    @Override
    public void setThundering(boolean b) {
        this.getBukkitWorld().setThundering(b);
    }

    @Override
    public void setWeatherDuration(int duration) {
        this.getBukkitWorld().setWeatherDuration(duration);
    }

    @Override
    public boolean playEffect(AbstractLocation location, int type) {
        return this.playEffect(location, type, 0);
    }

    @Override
    public boolean playEffect(AbstractLocation location, int type, int data) {
        World world = this.getBukkitWorld();
        Effect effect = effects.get(type);
        if (effect == null) {
            return false;
        }
        world.playEffect(BukkitAdapter.adapt(location), effect, data);
        return true;
    }

    @Override
    public byte getLightLevel(AbstractLocation l) {
        return BukkitAdapter.adapt(l).getBlock().getLightLevel();
    }

    @Override
    public byte getLightLevelFromBlocks(AbstractLocation l) {
        return this.getBukkitWorld().getBlockAt(l.getBlockX(), l.getBlockY(), l.getBlockZ()).getLightFromBlocks();
    }

    @Override
    public byte getLightLevelFromSky(AbstractLocation l) {
        return this.getBukkitWorld().getBlockAt(l.getBlockX(), l.getBlockY(), l.getBlockZ()).getLightFromSky();
    }

    @Override
    public AbstractLocation getSpawnLocation() {
        if (this.getBukkitWorld() == null) {
            return null;
        }
        return BukkitAdapter.adapt(this.getBukkitWorld().getSpawnLocation());
    }

    @Override
    public boolean isChunkLoaded(int x, int z) {
        if (this.getBukkitWorld() == null) {
            return false;
        }
        return MythicMobs.inst().getVolatileCodeHandler().getWorldHandler().isChunkLoaded(this, x, z);
    }

    @Override
    public int getEntitiesInChunk(int x, int z) {
        return MythicMobs.inst().getVolatileCodeHandler().getWorldHandler().getEntitiesInChunk(this, x, z);
    }

    @Override
    public boolean isLocationLoaded(AbstractLocation abstractLocation) {
        if (this.getBukkitWorld() == null) {
            return false;
        }
        Location loc = BukkitAdapter.adapt(abstractLocation);
        int x = loc.getBlockX() >> 4;
        int z = loc.getBlockZ() >> 4;
        return this.getBukkitWorld().isChunkLoaded(x, z);
    }

    @Override
    public List<AbstractPlayer> getPlayersNearLocation(AbstractLocation location, int radius) {
        ArrayList<AbstractPlayer> pl = new ArrayList<AbstractPlayer>();
        Location l = BukkitAdapter.adapt(location);
        for (Player p : this.getBukkitWorld().getPlayers()) {
            if (p.getLocation().distanceSquared(l) <= Math.pow(radius, 2.0)) {
                // empty if block
            }
            pl.add(BukkitAdapter.adapt(p));
        }
        return pl;
    }

    @Override
    public AbstractBiome getLocationBiome(AbstractLocation abstractLocation) {
        Location l = BukkitAdapter.adapt(abstractLocation);
        return BukkitAdapter.adapt(l.getBlock().getBiome());
    }

    @Override
    public long getFullTime() {
        if (this.getBukkitWorld() == null) {
            return 0L;
        }
        return this.getBukkitWorld().getFullTime();
    }

    static {
        for (Effect effect : Effect.values()) {
            effects.put(effect.getId(), effect);
        }
    }
}

