/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobItemGenerateEvent;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.items.ItemFactory;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.Optional;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitItemStack
extends ItemFactory
implements AbstractItemStack,
Cloneable {
    private ItemType itemType = ItemType.NORMAL;
    private Object mythicItem = null;
    private int amount = 1;

    public BukkitItemStack(String type) {
        if (type.toLowerCase().startsWith("mmoitems.")) {
            this.itemType = ItemType.MMOITEMS;
            this.mythicItem = MythicMobs.inst().getCompatibility().getMMOItems().get().getCustomItem(type.substring(9));
            return;
        }
        if (type.toLowerCase().startsWith("droptable.")) {
            this.itemType = ItemType.MYTHIC_DROPTABLE;
            return;
        }
        Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(type);
        if (maybeItem.isPresent()) {
            this.itemType = ItemType.MYTHIC;
            this.mythicItem = maybeItem.get();
        } else {
            Material material = Material.matchMaterial((String)type.toUpperCase());
            if (material == null) {
                throw new IllegalArgumentException("BukkitItemStack Material cannot be null (could not find material " + type + ")");
            }
            this.type(material);
        }
    }

    public BukkitItemStack(ItemStack item) {
        super(item);
    }

    public BukkitItemStack(Material material) {
        super(new ItemStack(material));
    }

    @Override
    public BukkitItemStack amount(int d) {
        if (this.itemType == ItemType.NORMAL) {
            super.amount(d);
        }
        this.amount = d;
        return this;
    }

    @Override
    public BukkitItemStack data(int d) {
        super.durability(d);
        return this;
    }

    public BukkitItemStack colorData(DyeColor dc) {
        this.data(dc.getWoolData());
        return this;
    }

    public CompoundTag getNBT() {
        return MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData(this.build());
    }

    @Override
    public ItemStack build() {
        if (this.itemType == ItemType.MMOITEMS) {
            return (ItemStack)this.mythicItem;
        }
        if (this.itemType == ItemType.MYTHIC) {
            MythicMobItemGenerateEvent event = new MythicMobItemGenerateEvent((MythicItem)this.mythicItem, BukkitAdapter.adapt(((MythicItem)this.mythicItem).generateItemStack(1)));
            event = Events.callAndReturn(event);
            ItemStack item = event.getItemStack();
            if (ServerVersion.isPaper()) {
                item = item.ensureServerConversions();
            }
            return item;
        }
        return super.build();
    }

    public BukkitItemStack clone() {
        return new BukkitItemStack(this.build());
    }

    public boolean isSimilar(ItemStack item) {
        ItemStack compitem;
        CompoundTag tagComp;
        if (this.itemType == ItemType.MMOITEMS) {
            CompoundTag tagBase = MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData((ItemStack)this.mythicItem);
            CompoundTag tagComp2 = MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData(item);
            if (!tagBase.getString("MMOITEMS_ITEM_TYPE").equals(tagComp2.getString("MMOITEMS_ITEM_TYPE"))) {
                return false;
            }
            return tagBase.getString("MMOITEMS_ITEM_ID").equals(tagComp2.getString("MMOITEMS_ITEM_ID"));
        }
        if (this.itemType == ItemType.MYTHIC && (tagComp = MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData(item)).containsKey("MYTHIC_TYPE")) {
            String mythicType = ((MythicItem)this.mythicItem).getInternalName();
            if (tagComp.getString("MYTHIC_TYPE").equals(mythicType)) {
                return true;
            }
        }
        if ((compitem = this.build()).getType() != item.getType()) {
            return false;
        }
        if (compitem.hasItemMeta()) {
            if (!item.hasItemMeta()) {
                return false;
            }
            ItemMeta thisMeta = compitem.getItemMeta();
            ItemMeta thatMeta = item.getItemMeta();
            if (thisMeta.hasCustomModelData()) {
                if (!thatMeta.hasCustomModelData()) {
                    return false;
                }
                if (thisMeta.getCustomModelData() != thatMeta.getCustomModelData()) {
                    return false;
                }
            }
        }
        return true;
    }

    public int getAmount() {
        return this.amount;
    }

    private static enum ItemType {
        NORMAL,
        MYTHIC,
        MYTHIC_DROPTABLE,
        MMOITEMS;

    }
}

