/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitArmorStand;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitAxolotl;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyDrowned;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyHusk;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyPigZombie;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyPigZombieVillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyPiglinBrute;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyZoglin;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyZombie;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBabyZombieVillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBat;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBee;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitBlaze;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitCat;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitCaveSpider;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitChicken;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitCod;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitCow;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitCreeper;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitCustom;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitDolphin;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitDonkey;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitDrowned;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitElderGuardian;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitEnderDragon;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitEnderman;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitEndermite;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitEvoker;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitExperienceOrb;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitFallingBlock;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitFox;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitGhast;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitGiant;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitGlowSquid;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitGoat;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitGuardian;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitHoglin;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitHorse;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitHusk;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitIllusioner;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitIronGolem;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitLlama;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitMagmaCube;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitMarker;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitMule;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitMushroomCow;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitOcelot;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPanda;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitParrot;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPhantom;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPig;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPigZombie;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPigZombieVillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPiglin;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPiglinBrute;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPolarBear;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitPufferFish;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitRabbit;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitRavager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSalmon;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSheep;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitShulker;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSilverfish;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSkeleton;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSkeletonHorse;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSlime;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSnowman;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSpider;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitSquid;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitStray;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitStrider;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitTNT;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitTraderLlama;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitTropicalFish;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitTurtle;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitVex;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitVillager;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitVindicator;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitWanderingTrader;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitWitch;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitWither;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitWitherSkeleton;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitWolf;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitZoglin;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitZombie;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitZombieHorse;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitZombieVillager;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntityType;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.HashMap;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public abstract class BukkitEntityType
extends MythicEntity {
    private static final HashMap<MythicEntityType, Class<? extends BukkitEntityType>> ENTITIES = new HashMap();
    private static Boolean isSpawning = false;

    @Override
    public AbstractEntity spawn(AbstractLocation location, SpawnReason reason) {
        return this.spawn(location, reason);
    }

    @Override
    public AbstractEntity spawn(AbstractLocation location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity entity = this.spawn(BukkitAdapter.adapt(location), reason, prespawnFunc);
        entity = this.applyOptions(entity);
        return BukkitAdapter.adapt(entity);
    }

    @Override
    public AbstractEntity spawnBaseEntity(AbstractLocation location, SpawnReason reason) {
        Entity entity = this.spawn(BukkitAdapter.adapt(location), reason, null);
        return BukkitAdapter.adapt(entity);
    }

    public Entity spawn(Location location, SpawnReason reason) {
        return this.spawn(location, reason, null);
    }

    public abstract Entity spawn(Location var1, SpawnReason var2, Consumer<Entity> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entity spawnEntity(Location location, EntityType type, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        isSpawning = true;
        try {
            if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                Entity entity2 = location.getWorld().spawnEntity(location, type, reason.getBukkitReason(), entity -> {
                    if (prespawnFunc != null) {
                        prespawnFunc.accept((Entity)entity);
                    }
                });
                return entity2;
            }
            Entity entity3 = location.getWorld().spawnEntity(location, type);
            if (prespawnFunc != null) {
                prespawnFunc.accept(entity3);
            }
            Entity entity4 = entity3;
            return entity4;
        }
        finally {
            isSpawning = false;
        }
    }

    public abstract Entity applyOptions(Entity var1);

    public abstract boolean compare(Entity var1);

    public static BukkitEntityType getMythicEntity(MythicMob mm3) {
        return BukkitEntityType.getMythicEntity(mm3.getEntityType());
    }

    public static BukkitEntityType getMythicEntity(String s2) {
        MythicEntityType met = MythicEntityType.get(s2);
        if (met == null) {
            return null;
        }
        return BukkitEntityType.getMythicEntity(met);
    }

    public static BukkitEntityType getMythicEntity(MythicEntityType entityType) {
        if (entityType == null) {
            return null;
        }
        Class<? extends BukkitEntityType> clazz = ENTITIES.get((Object)entityType);
        if (clazz == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! MythicEntityType not found", new Object[0]);
            try {
                clazz = BukkitCustom.class;
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (ConfigManager.debugLevel >= 1) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            if (ConfigManager.debugLevel >= 1) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Boolean getIsSpawning() {
        return isSpawning;
    }

    static {
        ENTITIES.put(MythicEntityType.ARMOR_STAND, BukkitArmorStand.class);
        ENTITIES.put(MythicEntityType.AXOLOTL, BukkitAxolotl.class);
        ENTITIES.put(MythicEntityType.BABY_DROWNED, BukkitBabyDrowned.class);
        ENTITIES.put(MythicEntityType.BABY_HUSK, BukkitBabyHusk.class);
        ENTITIES.put(MythicEntityType.BABY_PIGLIN, BukkitPiglin.class);
        ENTITIES.put(MythicEntityType.BABY_PIGLIN_BRUTE, BukkitBabyPiglinBrute.class);
        ENTITIES.put(MythicEntityType.BABY_PIG_ZOMBIE, BukkitBabyPigZombie.class);
        ENTITIES.put(MythicEntityType.BABY_PIG_ZOMBIE_VILLAGER, BukkitBabyPigZombieVillager.class);
        ENTITIES.put(MythicEntityType.BABY_ZOGLIN, BukkitBabyZoglin.class);
        ENTITIES.put(MythicEntityType.BABY_ZOMBIE, BukkitBabyZombie.class);
        ENTITIES.put(MythicEntityType.BABY_ZOMBIE_VILLAGER, BukkitBabyZombieVillager.class);
        ENTITIES.put(MythicEntityType.BAT, BukkitBat.class);
        ENTITIES.put(MythicEntityType.BEE, BukkitBee.class);
        ENTITIES.put(MythicEntityType.BLAZE, BukkitBlaze.class);
        ENTITIES.put(MythicEntityType.CAVE_SPIDER, BukkitCaveSpider.class);
        ENTITIES.put(MythicEntityType.CHICKEN, BukkitChicken.class);
        ENTITIES.put(MythicEntityType.CAT, BukkitCat.class);
        ENTITIES.put(MythicEntityType.COD, BukkitCod.class);
        ENTITIES.put(MythicEntityType.COW, BukkitCow.class);
        ENTITIES.put(MythicEntityType.CREEPER, BukkitCreeper.class);
        ENTITIES.put(MythicEntityType.CUSTOM, BukkitCustom.class);
        ENTITIES.put(MythicEntityType.DOLPHIN, BukkitDolphin.class);
        ENTITIES.put(MythicEntityType.DONKEY, BukkitDonkey.class);
        ENTITIES.put(MythicEntityType.DROWNED, BukkitDrowned.class);
        ENTITIES.put(MythicEntityType.ELDER_GUARDIAN, BukkitElderGuardian.class);
        ENTITIES.put(MythicEntityType.ENDERMAN, BukkitEnderman.class);
        ENTITIES.put(MythicEntityType.ENDERMITE, BukkitEndermite.class);
        ENTITIES.put(MythicEntityType.ENDER_DRAGON, BukkitEnderDragon.class);
        ENTITIES.put(MythicEntityType.EVOKER, BukkitEvoker.class);
        ENTITIES.put(MythicEntityType.EXPERIENCE_ORB, BukkitExperienceOrb.class);
        ENTITIES.put(MythicEntityType.FALLING_BLOCK, BukkitFallingBlock.class);
        ENTITIES.put(MythicEntityType.FOX, BukkitFox.class);
        ENTITIES.put(MythicEntityType.GHAST, BukkitGhast.class);
        ENTITIES.put(MythicEntityType.GIANT, BukkitGiant.class);
        ENTITIES.put(MythicEntityType.GOAT, BukkitGoat.class);
        ENTITIES.put(MythicEntityType.GLOW_SQUID, BukkitGlowSquid.class);
        ENTITIES.put(MythicEntityType.GUARDIAN, BukkitGuardian.class);
        ENTITIES.put(MythicEntityType.HOGLIN, BukkitHoglin.class);
        ENTITIES.put(MythicEntityType.HORSE, BukkitHorse.class);
        ENTITIES.put(MythicEntityType.HUSK, BukkitHusk.class);
        ENTITIES.put(MythicEntityType.ILLUSIONER, BukkitIllusioner.class);
        ENTITIES.put(MythicEntityType.IRON_GOLEM, BukkitIronGolem.class);
        ENTITIES.put(MythicEntityType.LLAMA, BukkitLlama.class);
        ENTITIES.put(MythicEntityType.MAGMA_CUBE, BukkitMagmaCube.class);
        ENTITIES.put(MythicEntityType.MARKER, BukkitMarker.class);
        ENTITIES.put(MythicEntityType.MULE, BukkitMule.class);
        ENTITIES.put(MythicEntityType.MUSHROOM_COW, BukkitMushroomCow.class);
        ENTITIES.put(MythicEntityType.OCELOT, BukkitOcelot.class);
        ENTITIES.put(MythicEntityType.PANDA, BukkitPanda.class);
        ENTITIES.put(MythicEntityType.PARROT, BukkitParrot.class);
        ENTITIES.put(MythicEntityType.PHANTOM, BukkitPhantom.class);
        ENTITIES.put(MythicEntityType.PIG, BukkitPig.class);
        ENTITIES.put(MythicEntityType.PIGLIN, BukkitPiglin.class);
        ENTITIES.put(MythicEntityType.PIGLIN_BRUTE, BukkitPiglinBrute.class);
        ENTITIES.put(MythicEntityType.PIG_ZOMBIE, BukkitPigZombie.class);
        ENTITIES.put(MythicEntityType.PIG_ZOMBIE_VILLAGER, BukkitPigZombieVillager.class);
        ENTITIES.put(MythicEntityType.PILLAGER, BukkitPillager.class);
        ENTITIES.put(MythicEntityType.POLAR_BEAR, BukkitPolarBear.class);
        ENTITIES.put(MythicEntityType.PRIMED_TNT, BukkitTNT.class);
        ENTITIES.put(MythicEntityType.PUFFERFISH, BukkitPufferFish.class);
        ENTITIES.put(MythicEntityType.RABBIT, BukkitRabbit.class);
        ENTITIES.put(MythicEntityType.RAVAGER, BukkitRavager.class);
        ENTITIES.put(MythicEntityType.SALMON, BukkitSalmon.class);
        ENTITIES.put(MythicEntityType.SHEEP, BukkitSheep.class);
        ENTITIES.put(MythicEntityType.SHULKER, BukkitShulker.class);
        ENTITIES.put(MythicEntityType.SILVERFISH, BukkitSilverfish.class);
        ENTITIES.put(MythicEntityType.SKELETON, BukkitSkeleton.class);
        ENTITIES.put(MythicEntityType.SKELETON_HORSE, BukkitSkeletonHorse.class);
        ENTITIES.put(MythicEntityType.SLIME, BukkitSlime.class);
        ENTITIES.put(MythicEntityType.SNOWMAN, BukkitSnowman.class);
        ENTITIES.put(MythicEntityType.SPIDER, BukkitSpider.class);
        ENTITIES.put(MythicEntityType.STRAY, BukkitStray.class);
        ENTITIES.put(MythicEntityType.STRIDER, BukkitStrider.class);
        ENTITIES.put(MythicEntityType.SQUID, BukkitSquid.class);
        ENTITIES.put(MythicEntityType.TRADER_LLAMA, BukkitTraderLlama.class);
        ENTITIES.put(MythicEntityType.TROPICAL_FISH, BukkitTropicalFish.class);
        ENTITIES.put(MythicEntityType.TURTLE, BukkitTurtle.class);
        ENTITIES.put(MythicEntityType.VEX, BukkitVex.class);
        ENTITIES.put(MythicEntityType.VILLAGER, BukkitVillager.class);
        ENTITIES.put(MythicEntityType.VINDIOCELOTOR, BukkitVindicator.class);
        ENTITIES.put(MythicEntityType.VINDICATOR, BukkitVindicator.class);
        ENTITIES.put(MythicEntityType.WANDERING_TRADER, BukkitWanderingTrader.class);
        ENTITIES.put(MythicEntityType.WITCH, BukkitWitch.class);
        ENTITIES.put(MythicEntityType.WITHER, BukkitWither.class);
        ENTITIES.put(MythicEntityType.WITHER_SKELETON, BukkitWitherSkeleton.class);
        ENTITIES.put(MythicEntityType.WOLF, BukkitWolf.class);
        ENTITIES.put(MythicEntityType.ZOGLIN, BukkitZoglin.class);
        ENTITIES.put(MythicEntityType.ZOMBIE, BukkitZombie.class);
        ENTITIES.put(MythicEntityType.ZOMBIE_HORSE, BukkitZombieHorse.class);
        ENTITIES.put(MythicEntityType.ZOMBIE_VILLAGER, BukkitZombieVillager.class);
    }
}

