/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.shadow;

import io.lumine.shadow.Reflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

final class BeanUtils {
    public static Method getMatchingMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            Reflection.ensureAccessible(method);
            return method;
        }
        catch (NoSuchMethodException method) {
            Method bestMatch = null;
            float bestMatchCost = Float.MAX_VALUE;
            block2: for (Method method2 : clazz.getDeclaredMethods()) {
                Class<?>[] methodsParams;
                if (!method2.getName().equals(methodName) || (methodsParams = method2.getParameterTypes()).length != parameterTypes.length) continue;
                for (int i = 0; i < methodsParams.length; ++i) {
                    if (!BeanUtils.isAssignmentCompatible(methodsParams[i], parameterTypes[i])) continue block2;
                }
                float cost = BeanUtils.getTotalTransformationCost(parameterTypes, method2.getParameterTypes());
                if (!(cost < bestMatchCost)) continue;
                bestMatch = method2;
                bestMatchCost = cost;
            }
            if (bestMatch == null && clazz.getSuperclass() != null) {
                bestMatch = BeanUtils.getMatchingMethod(clazz.getSuperclass(), methodName, parameterTypes);
            }
            if (bestMatch == null && clazz.getInterfaces() != null) {
                Class<?> i;
                Class<?>[] interfaces;
                Class<?>[] classArray = interfaces = clazz.getInterfaces();
                int n = classArray.length;
                for (int j = 0; j < n && (bestMatch = BeanUtils.getMatchingMethod(i = classArray[j], methodName, parameterTypes)) == null; ++j) {
                }
            }
            return bestMatch;
        }
    }

    public static Constructor<?> getMatchingConstructor(Class<?> clazz, Class<?>[] parameterTypes) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            Reflection.ensureAccessible(constructor);
            return constructor;
        }
        catch (NoSuchMethodException constructor) {
            Constructor<?> bestMatch = null;
            float bestMatchCost = Float.MAX_VALUE;
            block2: for (Constructor<?> constructor2 : clazz.getDeclaredConstructors()) {
                Class<?>[] methodsParams = constructor2.getParameterTypes();
                if (methodsParams.length != parameterTypes.length) continue;
                for (int n = 0; n < methodsParams.length; ++n) {
                    if (!BeanUtils.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) continue block2;
                }
                float cost = BeanUtils.getTotalTransformationCost(parameterTypes, constructor2.getParameterTypes());
                if (!(cost < bestMatchCost)) continue;
                bestMatch = constructor2;
                bestMatchCost = cost;
            }
            return bestMatch;
        }
    }

    private static float getTotalTransformationCost(Class<?>[] srcArgs, Class<?>[] destArgs) {
        float totalCost = 0.0f;
        for (int i = 0; i < srcArgs.length; ++i) {
            Class<?> srcClass = srcArgs[i];
            Class<?> destClass = destArgs[i];
            totalCost += BeanUtils.getObjectTransformationCost(srcClass, destClass);
        }
        return totalCost;
    }

    private static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
        float cost = 0.0f;
        while (srcClass != null && !destClass.equals(srcClass)) {
            Class<?> destClassWrapperClazz;
            if (destClass.isPrimitive() && (destClassWrapperClazz = BeanUtils.getPrimitiveWrapper(destClass)) != null && destClassWrapperClazz.equals(srcClass)) {
                cost += 0.25f;
                break;
            }
            if (destClass.isInterface() && BeanUtils.isAssignmentCompatible(destClass, srcClass)) {
                cost += 0.25f;
                break;
            }
            cost += 1.0f;
            srcClass = srcClass.getSuperclass();
        }
        if (srcClass == null) {
            cost += 1.5f;
        }
        return cost;
    }

    private static boolean isAssignmentCompatible(Class<?> parameterType, Class<?> parameterization) {
        Class<?> parameterWrapperClazz;
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        if (parameterType.isPrimitive() && (parameterWrapperClazz = BeanUtils.getPrimitiveWrapper(parameterType)) != null) {
            return parameterWrapperClazz.equals(parameterization);
        }
        return false;
    }

    private static Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Void.TYPE) {
            return Void.class;
        }
        return null;
    }

    private BeanUtils() {
    }
}

